(*| 21:51 27/04/1991 *)
UNIT DisUtils;

INTERFACE

USES Crt,StdTypes;

CONST
  MaxLabel = 2000;

TYPE
  BytePointer = ^Byte;
  OpcodeType = STRING[4];
  AddressModeType = (Implied,Immediate,Direct,Indexed,Extended,Relative,Page48);
  StyleType = (CodeStyle,ByteStyle,WordStyle,StringStyle,TableStyle,Remark);
  LabelClassType = (Location,ByteLabel,WordLabel,Mixed);
  LabelType = RECORD
                Value: Word;
                Class: LabelClassType;
              END;

VAR
  ByteFileName: STRING[12];
  ByteFileSize: Integer;
  EndOfByteFile: Boolean;
  StartAddress,CurrentAddress,EndAddress: LongInt;
  Pass,NumOfDataBytes: Integer;
  DataString,OpcodeString: LineString;
  OpcodeAddressMode: AddressModeType;
  ByteBuf,BufPtr,BufTop: BytePointer;
  Labels: ARRAY[1..MaxLabel] OF LabelType;
  NextLabel,HiLabel: Integer;
  NextLabelValue,SeqValue: LongInt;
  SeqFile,AsmFile: TEXT;
  NeedBlankLine,SeqExists,SaveToDisk,QuietScreen: Boolean;
  Style,NextStyle: StyleType;
  NextByteWidth,ByteWidth: Integer;
  Comment:LineString;

FUNCTION IndexPtr(OldPtr:BytePointer; Index: Integer):BytePointer;

PROCEDURE ReadFileToBuf;

PROCEDURE OpenSeqFile;

PROCEDURE OpenAsmFile;

FUNCTION Hex1(C:CHAR):BYTE;

FUNCTION HexBin(HexPair: String):BYTE;

FUNCTION HexString(N,Size: Integer): String;

FUNCTION AddressInRange(A:Word): Boolean;

PROCEDURE NextSeq;

PROCEDURE InsertRemark(VAR LineNum: Integer);

PROCEDURE DoBlankLine(VAR LineNum: Integer);

FUNCTION GetNextByte: Byte;

PROCEDURE BadByte;

FUNCTION AddedLabel(A:Word; C:LabelClassType): Boolean;

PROCEDURE AddLabel(A:Word; C:LabelClassType);

FUNCTION LabelClassChar(Class:LabelClassType):Char;

PROCEDURE ShowLabels;

PROCEDURE InsertLabel(VAR LineNum: Integer);

IMPLEMENTATION

FUNCTION IndexPtr(OldPtr:BytePointer; Index: Integer):BytePointer;
BEGIN
  IndexPtr:=Ptr(Seg(OldPtr^),Ofs(OldPtr^)+Index);
END;  { IndexPtr }

PROCEDURE ReadFileToBuf;
VAR
  ByteFile: FILE;
  NumRead: Integer;
BEGIN
  Assign(ByteFile,ByteFileName);
  Reset(ByteFile,1);
  ByteFileSize:=FileSize(ByteFile);
  GetMem(ByteBuf,ByteFileSize);
  BlockRead(ByteFile,ByteBuf^,ByteFileSize,NumRead);
  Close(ByteFile);
  BufPtr:=ByteBuf;
  BufTop:=IndexPtr(BufPtr,ByteFileSize);
END;  { ReadFileToBuf }

PROCEDURE OpenSeqFile;
VAR
  SeqFileName:String[12];
  I: Integer;
BEGIN
  SeqExists:=False;
  I:=POS('.',ByteFileName);
  IF I > 0 THEN BEGIN
    SeqFileName:=COPY(ByteFileName,1,I) + 'SEQ';
    Assign(SeqFile,SeqFileName);
{$I-}
    Reset(SeqFile);
{$I+}
    SeqExists:=(IOResult=0);
    IF NOT SeqExists THEN
      Writeln('Unable to open sequence file ',SeqFileName)
    ELSE
      Close(SeqFile);
  END;
END;  { OpenSeqFile }

PROCEDURE OpenAsmFile;
VAR
  AsmFileName:String[12];
  I: Integer;
BEGIN
  SaveToDisk:=False;
  I:=POS('.',ByteFileName);
  IF I > 0 THEN BEGIN
    AsmFileName:=COPY(ByteFileName,1,I) + 'ASM';
    Assign(AsmFile,AsmFileName);
    ReWrite(AsmFile);
    SaveToDisk:=True;
  END;
END;  { OpenAsmFile }

FUNCTION Hex1(C:CHAR):BYTE;
VAR
  I:Integer;
BEGIN
  I:=ORD(UpCase(C));
  IF ((I < $30) OR (I > $47)) THEN
    Hex1:=0
  ELSE IF I <= $39 THEN
    Hex1:=I-$30
  ELSE IF I > $40 THEN
    Hex1:=I-$37
  ELSE
    Hex1:=0;
END;

FUNCTION HexBin(HexPair: String):BYTE;

BEGIN
  IF LENGTH(HexPair) = 2 THEN
    HexBin:=(16 * Hex1(HexPair[1])) + Hex1(HexPair[2])
  ELSE HexBin:=0;
END;  { HexBin }

FUNCTION HexString(N,Size: Integer): String;

Var
  I,J,K,Mask: Integer;
  Result: String;

BEGIN
  Result:='';
  J:=(Size-1)*4;
  Mask:=15 SHL J;
  FOR I:=1 TO Size DO
    BEGIN
      K:=(N AND Mask) SHR J;
      IF K > 9 THEN
        Result:=Result + Chr(K+55)
      ELSE
        Result:=Result + Chr(K+48);
      Mask:=Mask SHR 4;
      J:=J-4;
    END;
  HexString:=Result;
END;  { HexString }

FUNCTION AddressInRange(A:Word): Boolean;
VAR
  LI:LongInt;
BEGIN
  LI:=LongInt(A);
  AddressInRange:=((A >= StartAddress) AND (A < EndAddress));
END;

PROCEDURE NextSeq;
VAR
  L: LineString;
  I: Integer;
BEGIN
  IF EOF(SeqFile) THEN
    SeqValue:=$FFFF
  ELSE BEGIN
    Readln(SeqFile,L);
    SeqValue:=0;
    NextByteWidth:=8;
    I:= 1;
    WHILE L[I] > '/' DO BEGIN
      SeqValue:=SeqValue*16 + Hex1(L[I]);
      INC(I);
    END;
    WHILE L[I] <= ' ' DO
      INC(I);
    CASE UpCase(L[I]) OF
      'O': BEGIN
             StartAddress:=SeqValue;
             CurrentAddress:=StartAddress;
             EndAddress:=StartAddress+ByteFileSize;
           END;
      'C': NextStyle:=CodeStyle;
      'B': NextStyle:=ByteStyle;
      'W': NextStyle:=WordStyle;
      'S': NextStyle:=StringStyle;
      'T': NextStyle:=TableStyle;
      'R': BEGIN
             NextStyle:=Remark;
             Comment:=COPY(L,I+1,80);
           END;
    END;
    IF NOT (NextStyle IN [CodeStyle,Remark]) THEN
      IF Length(L) > I THEN
        NextByteWidth:=Hex1(L[I+1]);
  END;
END;  { NextSeq }

PROCEDURE InsertRemark(VAR LineNum: Integer);
BEGIN
  IF Pass <> 1 THEN BEGIN
    Comment:=';  '+Comment;
    IF NOT QuietScreen THEN BEGIN
      Write('':18);
      Writeln(Comment);
    END;
    IF SaveToDisk THEN
      Writeln(AsmFile,Comment);
  END;
END;

PROCEDURE DoBlankLine(VAR LineNum: Integer);
BEGIN
  IF Pass <> 1 THEN BEGIN
    IF NOT QuietScreen THEN BEGIN
      Writeln;
      INC(LineNum);
    END;
    IF SaveToDisk THEN
      Writeln(AsmFile);
  END;
END;  { DoBlankLine }

FUNCTION GetNextByte: Byte;
VAR
  B: Byte;
BEGIN
  B:=0;
  IF BufPtr=BufTop THEN
    EndOfByteFile:=True
  ELSE BEGIN
    B:=BufPtr^;
    BufPtr:=IndexPtr(BufPtr,1);
    DataString:=DataString + HexString(B,2);
    INC(CurrentAddress);
  END;
  GetNextByte:=B;
END;  { GetNextByte }

PROCEDURE BadByte;
BEGIN
END;  { BadByte }

FUNCTION AddedLabel(A:Word; C:LabelClassType): Boolean;
VAR
  Exists: Boolean;
  I,J: Integer;
BEGIN
  Exists:=False;
  I:=1;
  IF A > Labels[1].Value THEN REPEAT
    Exists:=(Labels[I].Value=A);
    IF NOT Exists THEN
      INC(I);
  UNTIL (Exists OR (I >= HiLabel) OR (A < Labels[I].Value));
  IF Exists THEN WITH Labels[I] DO BEGIN
    IF Class <> C THEN
      Class:=Mixed;
  END ELSE BEGIN
    IF I >= HiLabel THEN WITH Labels[HiLabel] DO BEGIN
      Value:=A;
      Class:=C;
    END ELSE BEGIN
      FOR J:=HiLabel DOWNTO I+1 DO
        Labels[J]:=Labels[J-1];
      WITH Labels[I] DO BEGIN
        Value:=A;
        Class:=C;
      END;
    END;
  END;
  IF HiLabel < MaxLabel THEN
    AddedLabel:=NOT Exists
  ELSE BEGIN
    AddedLabel:=False;
    IF NOT Exists THEN
      Writeln('Too many labels');
  END;
END;  { AddedLabel }

PROCEDURE AddLabel(A:Word; C:LabelClassType);
BEGIN
  IF NOT QuietScreen THEN
    Write(HexString(CurrentAddress,4),',',HexString(A,4),'.');
  IF HiLabel > 1 THEN BEGIN
    IF AddedLabel(A,C) THEN
      INC(HiLabel);
  END ELSE WITH Labels[1] DO BEGIN
    Value:=A;
    Class:=C;
    HiLabel:=2;
  END;
END;  { AddLabel }

FUNCTION LabelClassChar(Class:LabelClassType):Char;
VAR
  Result:Char;
BEGIN
  CASE Class OF
    Location : Result:='L';
    ByteLabel: Result:='B';
    WordLabel: Result:='W';
    Mixed    : Result:='M';
  ELSE Result:='?';
  END;
  LabelClassChar:=Result;
END;  { LabelClassChar }

PROCEDURE ShowLabels;
VAR
  I: Integer;
BEGIN
  Writeln('Labels : ');
  IF HiLabel > 1 THEN FOR I:=1 TO HiLabel-1 DO WITH Labels[I] DO BEGIN
    Write(HexString(Value,4),' ',LabelClassChar(Class),'  ');
  END;
  Writeln;
END;  { ShowLabels }

PROCEDURE InsertLabel(VAR LineNum: Integer);
BEGIN
  IF NextLabel < HiLabel THEN BEGIN
    WHILE ((NextLabel < HiLabel) AND
           (CurrentAddress > NextLabelValue)) DO BEGIN
      WITH Labels[NextLabel] DO BEGIN
        IF NOT QuietScreen THEN BEGIN
          Write(' ':18);
          Writeln(';  ',LabelClassChar(Class),HexString(Value,4),
                  '  ',HexString(CurrentAddress,4));
        END;
        IF SaveToDisk THEN
          Writeln(AsmFile,';  ',LabelClassChar(Class),HexString(Value,4),
                          '  ',HexString(CurrentAddress,4));
      END;
      INC(NextLabel);
      NextLabelValue:=LongInt(Labels[NextLabel].Value);
    END;
    IF NextLabelValue = CurrentAddress THEN WITH Labels[NextLabel] DO BEGIN
      IF NOT QuietScreen THEN BEGIN
        Write(' ':18);
        Writeln(LabelClassChar(Class),HexString(Value,4),':');
        INC(LineNum);
      END;
      IF SaveToDisk THEN
        Writeln(AsmFile,LabelClassChar(Class),HexString(Value,4),':');
      INC(NextLabel);
      NextLabelValue:=LongInt(Labels[NextLabel].Value);
    END;
  END;
END;  { InsertLabel }

END.
